<?php
/* --------------------------------------------------------------
 AccountTemplate.php 2019-12-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class AccountTemplate
 * @package Gambio\Core\Configuration\Types
 */
class AccountTemplate implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $data = [
            [
                'text'  => $resolver->getText('GM_CFG_ACCOUNT', 'gm_general'),
                'value' => 'account',
            ],
            [
                'text'  => $resolver->getText('GM_CFG_GUEST', 'gm_general'),
                'value' => 'guest',
            ],
        ];
        
        return Options::fromArray($data);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}